import { defineConfig, loadEnv } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path';
import fs from 'fs';

export default defineConfig(({ mode }) => {
  // 加载环境变量
  const env = loadEnv(mode, process.cwd(), '')
  
  // 清理API基础URL，移除末尾的斜杠
  const apiBaseUrl = (env.VITE_API_BASE_URL).replace(/\/+$/, '');
  const basePath = env.VITE_BASE_PATH;
  const agentPath = env.VITE_SSE_PATH;
  
  return {
    base: basePath,
    plugins: [vue()],
    server: {
      host: '0.0.0.0',
      port: 3000,
      https: {
        key: fs.readFileSync('./localhost-key.pem'),
        cert: fs.readFileSync('./localhost.pem')
      },
      // 添加history fallback配置
      historyApiFallback: {
        rewrites: [
          { from: /^\/ai\/.*$/, to: '/ai/index.html' }
        ]
      },
      proxy: {
        // 同时配置两种路径的代理
        '/pedapi': {
          target: apiBaseUrl,
          changeOrigin: true,
          secure: false,
          configure: (proxy, options) => {
            proxy.on('error', (err, req, res) => {
              console.log('代理错误:', err);
            });
            proxy.on('proxyReq', (proxyReq, req, res) => {
              console.log('发送请求到:', options.target);
            });
          }
        },
        [agentPath]: {
          target: apiBaseUrl,
          changeOrigin: true,
          secure: false,
        },
        '/ifile': {
          target: apiBaseUrl,
          changeOrigin: true,
          secure: false,
        },
        '/WeChatOauth2': {
          target: apiBaseUrl,
          changeOrigin: true,
          secure: false,
        }
      },
    },
    build: {
      outDir: 'dist',
      assetsDir: 'assets',
      sourcemap: false
    },
    resolve: {
      alias: {
        '@': resolve(__dirname, 'src'),
        'echarts': 'echarts/dist/echarts.esm.js'
      }
    },
  }
})