import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import { setRouter } from './utils/router-manager'
import { initGlobalErrorHandler, handle401Error, is401Error } from './utils/error-handler'

// 引入ant-design-vue
import Antd from 'ant-design-vue';
import 'ant-design-vue/dist/antd.css';

// 引入中文语言包
import zhCN from 'ant-design-vue/es/locale/zh_CN';
import dayjs from 'dayjs';
import 'dayjs/locale/zh-cn';

// 配置dayjs为中文
dayjs.locale('zh-cn');

const app = createApp(App)
app.use(router)
app.use(Antd)

// 配置全局中文语言
app.config.globalProperties.$ANTD_LOCALE = zhCN;

// 设置全局路由实例
setRouter(router)

// 全局错误处理 - 项目级别的401拦截机制
app.config.errorHandler = (err, instance, info) => {
  console.error('Vue全局错误捕获:', err, info)
  
  // 处理401错误
  if (is401Error(err)) {
    console.log('Vue错误处理中检测到401，执行全局处理')
    handle401Error()
  }
}

// 初始化全局错误处理机制
initGlobalErrorHandler()

app.mount('#app')