import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path';
import fs from 'fs';
export default defineConfig({
  base: '/ai/', // 添加基础路径前缀
  plugins: [vue()],
  server: {
    host: '0.0.0.0',
    port: 3000,
    https: {
      key: fs.readFileSync('./localhost-key.pem'),
      cert: fs.readFileSync('./localhost.pem')
    },
    // 添加history fallback配置
    historyApiFallback: {
      rewrites: [
        { from: /^\/ai\/.*$/, to: '/ai/index.html' }
      ]
    },
    proxy: {
      '/pedapi': {
        target: 'http://peddev.cmic.com.cn',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
        configure: (proxy, options) => {
          proxy.on('error', (err, req, res) => {
            console.log('代理错误:', err);
          });
          proxy.on('proxyReq', (proxyReq, req, res) => {
            console.log('发送请求到:', options.target);
          });
        }
      },
      '/ifile': {
        target: 'http://peddev.cmic.com.cn',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
      },
     '/WeChatOauth2': {
        target: 'http://peddev.cmic.com.cn',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
      }
    },
  },
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
    sourcemap: false
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src'),
      'echarts': 'echarts/dist/echarts.esm.js'
    }
  },
})