import { createRouter, createWebHashHistory } from 'vue-router' // 改为Hash模式
import wechat from '../utils/wechat'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: () => import('../views/Home.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/history',
    name: 'History',
    component: () => import('../views/History.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import('../views/Login.vue')
  },
  {
    path: '/:pathMatch(.*)*',
    redirect: '/'
  }
]

const router = createRouter({
  history: createWebHashHistory('/ai/'), // 使用Hash模式
  routes
})

// 简化的路由守卫
router.beforeEach((to, from, next) => {
  if (to.meta.requiresAuth) {
    const status = wechat.checkLoginStatus()
    if (!status.isLoggedIn) {
      next('/login')
      return
    }
  }
  
  next()
})

export default router