import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path';

export default defineConfig({
  base: '/ai/', // 添加基础路径前缀
  plugins: [vue()],
  server: {
    host: '0.0.0.0',
    port: 3000,
    // 添加history fallback配置
    historyApiFallback: {
      rewrites: [
        { from: /^\/ai\/.*$/, to: '/ai/index.html' }
      ]
    },
    proxy: {
      '/pedapi': {
        target: 'http://peddev.cmic.com.cn',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
        configure: (proxy, options) => {
          proxy.on('error', (err, req, res) => {
            console.log('代理错误:', err);
          });
          proxy.on('proxyReq', (proxyReq, req, res) => {
            console.log('发送请求到:', options.target);
          });
        }
      },
     '/WeChatOauth2': {
        target: 'http://peddev.cmic.com.cn',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
        configure: (proxy, options) => {
          proxy.on('error', (err, req, res) => {
            console.log('代理错误:', err);
          });
          proxy.on('proxyReq', (proxyReq, req, res) => {
            console.log('发送请求到:', options.target);
          });
        }
      },
      // 修复pedService代理配置
      '/pedService': {
        target: 'http://10.17.86.37:8630',
        changeOrigin: true,  // 解决跨域问题
        secure: false,       // 允许不安全的SSL连接
        rewrite: (path) => path.replace(/^\/pedService/, '/pedService'), // 保留前缀
        configure: (proxy, options) => {
          proxy.on('error', (err, req, res) => {
            console.log('pedService代理错误:', err);
          });
          proxy.on('proxyReq', (proxyReq, req, res) => {
            console.log('pedService发送请求到本地服务:', options.target + req.url);
          });
          proxy.on('proxyRes', (proxyRes, req, res) => {
            console.log('pedService收到响应，状态码:', proxyRes.statusCode);
          });
        }
      }
    },
  },
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
    sourcemap: false
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src'),
      'echarts': 'echarts/dist/echarts.esm.js'
    }
  },
})