import axios from 'axios'

// 创建axios实例
const instance = axios.create({
    baseURL: '/',
    timeout: 10000,
    headers: {
        'Content-Type': 'application/json'
    }
})

// 请求拦截器 - 添加认证信息
instance.interceptors.request.use(
    (config) => {
        // 从localStorage获取用户信息
        const userData = localStorage.getItem('wechat_user')
        const { extMap = {} } = JSON.parse(userData || '{}')
        const userToken = extMap.sessionId;
        if (userToken) {
            try {
                config.headers['x-session-id'] = userToken || ''
            } catch (error) {
                console.warn('解析用户信息失败', error)
            }
        }
        return config
    },
    (error) => {
        return Promise.reject(error)
    }
)

import { navigateToLogin } from './router-manager'

// 响应拦截器 - 处理401错误
instance.interceptors.response.use(
    (response) => {
        return response
    },
    (error) => {
        if (error.response) {
            const { status } = error.response

            // 处理401未授权错误
            if (status === 401) {
                // 清除本地存储的用户信息
                localStorage.removeItem('wechat_user')

                // 使用全局路由管理器跳转
                navigateToLogin()

                return Promise.reject(new Error('未授权访问，请重新登录'))
            }

            // 其他错误处理
            console.error(`请求失败: ${status}`, error.response.data)
        } else if (error.request) {
            console.error('网络错误，请求未发送成功', error)
        } else {
            console.error('请求配置错误', error.message)
        }

        return Promise.reject(error)
    }
)

// 导出get和post方法
export const get = (url, config = {}) => instance.get(url, config)

export const post = (url, data = {}, config = {}) => instance.post(url, data, config)

// 导出实例（可选）
export default instance