// 引入axios
import { post } from './axios.js'

// 企业微信登录工具类 - 简化版本（直接从URL获取code）
class WeChatLogin {
  constructor() {
    this.corpId = 'ww88c20288b24a8e33' // 企业微信CorpID
    this.agentId = '1000002' // 应用AgentId
  }

  // 检查是否为企业微信浏览器
  checkWeChatWorkBrowser() {
    const ua = navigator.userAgent.toLowerCase()
    return ua.indexOf('wxwork') !== -1
  }

  // 从URL参数获取code
  getCodeFromURL() {
    const urlParams = new URLSearchParams(window.location.search)
    return urlParams.get('code')
  }

  // 企业微信静默登录 - 核心方法
  async silentLogin() {
    try {
      // 直接从URL获取code
      const code = this.getCodeFromURL()
      if (!code) {
        console.error('未找到code参数，请确保在企业微信内部应用中访问')
        return {
          isLoggedIn: false,
          message: '未找到code参数，请确保在企业微信内部应用中访问'
        }
      }

      // 获取用户信息
      const userInfo = await this.getUserInfo(code)
      
      return {
        isLoggedIn: true,
        code: code,
        userInfo: userInfo
      }
    } catch (error) {
      console.error('登录失败:', error.message)
      return {
        isLoggedIn: false,
        message: error.message || '登录失败'
      }
    }
  }

  // 获取用户信息 - 使用axios
  async getUserInfo(code) {
    try {
      const response = await post('/pedapi/pedService/wxcp/auth', {
        authCode: code
      })

      const result = response.data
      
      if (result.code === 0) {
        // 保存用户信息
        localStorage.setItem('wechat_user', JSON.stringify(result.data))
        return result.data
      } else {
        throw new Error(result.message || '获取用户信息失败')
      }
    } catch (error) {
      throw new Error(`获取用户信息失败: ${error.message}`)
    }
  }

  // 检查登录状态
  checkLoginStatus() {
    const userData = localStorage.getItem('wechat_user')
    if (userData) {
      try {
        return {
          isLoggedIn: true,
          userInfo: JSON.parse(userData)
        }
      } catch (error) {
        localStorage.removeItem('wechat_user')
      }
    }
    return { isLoggedIn: false }
  }

  // 退出登录
  logout() {
    localStorage.removeItem('wechat_user')
  }

  // 获取当前用户
  getCurrentUser() {
    const status = this.checkLoginStatus()
    return status.isLoggedIn ? status.userInfo : null
  }
}

export default new WeChatLogin()