import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import { setRouter } from './utils/router-manager'
import createFetchInterceptor from './utils/fetch-interceptor'

const app = createApp(App)
app.use(router)

// 设置全局路由实例
setRouter(router)

// 启用fetch拦截器 - 自动处理401错误
createFetchInterceptor()

app.mount('#app')