/**
 * 数字格式化工具函数
 * 功能：
 * 1. 直接截断而非四舍五入
 * 2. 最多保留两位小数，自动移除末尾0
 * 3. 智能判断整数和小数显示方式
 * 4. 支持亿、万单位自动转换
 */

export const formatNumber = (value: any): string => {
  if (value === null || value === undefined || value === '') return '';

  const num = parseFloat(value);
  if (isNaN(num)) return value;

  // 处理负数
  const isNegative = num < 0;
  const absNum = Math.abs(num);

  if (absNum >= 100000000) {
    // 亿级别
    const result = absNum / 100000000;
    const decimalPart = result % 1;
    if (decimalPart === 0) {
      return (isNegative ? '-' : '') + result.toString() + '亿';
    } else {
      // 最多保留两位小数
      const fixedResult = result.toFixed(2);
      // 移除末尾的0
      return (isNegative ? '-' : '') + fixedResult.replace(/\.?0+$/, '') + '亿';
    }
  } else if (absNum >= 10000) {
    // 万级别
    const result = absNum / 10000;
    const decimalPart = result % 1;
    if (decimalPart === 0) {
      return (isNegative ? '-' : '') + result.toString() + '万';
    } else {
      // 最多保留两位小数
      const fixedResult = result.toFixed(2);
      // 移除末尾的0
      return (isNegative ? '-' : '') + fixedResult.replace(/\.?0+$/, '') + '万';
    }
  } else {
    // 小于万
    const decimalPart = absNum % 1;
    if (decimalPart === 0) {
      return (isNegative ? '-' : '') + absNum.toString();
    } else {
      // 最多保留两位小数
      const fixedResult = absNum.toFixed(2);
      // 移除末尾的0
      return (isNegative ? '-' : '') + fixedResult.replace(/\.?0+$/, '');
    }
  }
};

/**
 * 获取颜色方案 - 自定义颜色方案
 */
export const getColors = () => {
  return [
    '#5B90F9', '#73DEB3', '#8074FF', '#00CDFE', '#FDDD60', '#FF8B45', '#F478D1', '#FF6F77', '#8D48E4',
    '#1890ff', '#52c41a', '#faad14', '#f5222d', '#722ed1', '#13c2c2',
    '#fa541c', '#eb2f96', '#a0d911', '#2f54eb', '#fa8c16', '#52c41a',
    '#13c2c2', '#1890ff', '#722ed1', '#faad14', '#f5222d', '#eb2f96',
    '#a0d911', '#2f54eb', '#fa8c16', '#52c41a', '#13c2c2', '#1890ff'
  ];
};