import { createRouter, createWebHistory } from 'vue-router'
import wechat from '../utils/wechat'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: () => import('../views/Home.vue'),
    meta: { requiresAuth: true }
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import('../views/Login.vue')
  },
  {
    path: '/:pathMatch(.*)*',
    redirect: '/'
  }
]

const router = createRouter({
  history: createWebHistory('/ai/'), // 添加基础路径
  routes
})

// 简化的路由守卫
router.beforeEach((to, from, next) => {
  if (to.meta.requiresAuth) {
    const status = wechat.checkLoginStatus()
    if (!status.isLoggedIn) {
      next('/login')
      return
    }
  }
  
  next()
})

export default router